function [TSA_PDF_data, TSA_PDF_fits, TSA_MSD_data, TSA_MSD_linearfits, TSA_MSD_nonlinfits] = Main_modified(traj,magnif,xposure)
%function [TSA_PDF_data, TSA_PDF_fits, TSA_MSD_data, TSA_MSD_linearfits, TSA_MSD_nonlinfits] = Main_modidied(traj,magnif,xposure)
%
%Originally written by Yin, Huerta, Steinberg, Zuniga from Bull Math Bio, 
%2009, 71, 1967-2024, Time series analysis of particle tracking data to
%anlayzed the data in Zuniga, Biophys J, 86, 2004, 2896-2909, Lateral diff
%in plasma membrane.  I modified it slightly to read in my data which is in
%an array of the format listed below.
%
%
%INPUTS:    TRAJ:       This array contains all the information learned
%                       about all the particles, stored in columns. A
%                       single trajectory may occupy many sequential rows.
%                       A single row details information about a feature in
%                       a particular frame, or that features trajectory
%                       from the previous frame to that frame.
%           TRAJ(:,1)   The x centroid positions, in pixels
%           TRAJ(:,2)   The y centroid positions, in pixels
%           TRAJ(:,3)   The integrated brightness of the features,
%                       background corrected.
%           TRAJ(:,4)   The radii of gyration squared of the features
%           TRAJ(:,5)   The eccentricity of the features
%           TRAJ(:,6)   The frame number (real frame number) of this row.
%           TRAJ(:,7)   The unique particle ID of this particle
%           TRAJ(:,8)   How many frames this particle has been tracked so
%                       far.
%           TRAJ(:,9)   The x displacement of the particle since its last
%                       position. Note, this will include -1000 for any
%                       frames where the position of the particle in the
%                       previous frame is unknown.
%           TRAJ(:,10)  The y displacement of the particle since its last
%                       position. Note, this will include -1000 for any
%                       frames where the position of the particle in the
%                       previous frame is unknown.
%           TRAJ(:,11)  The squared displacement of the particle to this
%                       point.
%           TRAJ(:,12)  Step size in microns, earlier in the program used
%                       to form trajectories:
%                       The presplicing alternating frame tracking unique
%                       particle ID. Even and odd sequences are
%                       differentiated throught the use of real and complex.
%           TRAJ(:,13)  The presplicing single frame tracking unique
%                       particle ID.
%           XPOSURE:    Kinetic cycle time in milliseconds, will be
%                       converted to seconds in this program.
%           MAGNIF:     The magnification the experiment was taken at (the
%                       magnification of the microscope generally).
%
%OUTPUTS:   TSA_PDF_data        Probability distribution of step size data,
%                               compiled from displacements in nm, bin size
%                               is set by the user (see line below starting:
%                               binsize = ), column 1 is bin center, column
%                               2 is frequency
%           TSA_PDF_fits        Best fits for the PDF data for the Weibull,
%                               Chi, LS, and GEV models (columns 2-5) with
%                               the displacement range (x axis) in column 1
%           TSA_MSD_data        Data points for mean squared displacement
%                               v. time delay in nm^2 and frame number
%           TSA_MSD_linearfits  Linear models w and w/o offset least squares fitted to
%                               the 1st tens points of MSD v. tau
%           TSA_MSD_nonlinfits  Same for non-linear models.
%
%Original authors: Stanley Steinberg
%Modified by Lindsay Elliott, UIUC and ND, 5/27/2010

% Code to analize the Martha Zuniga data.

%  Close all figures
   close all
%  Close all files
   fclose('all');
%  Save some results.
   tmpA1 = [];
   tmpB1 = [];
   tmpR1 = [];
   tmpA2 = [];
   tmpR2 = [];
   tmpa1 = [];
   tmpb1 = [];
   tmpr1 = [];
   tmpa2 = [];
   tmpr2 = [];
   tmpalpha1 = [];
   tmpalpha2 = [];
   tmpM2 = [];
   tmpL = [];
   tmpMSD = [];
%  Create the full file names.
%   names = strrep(strrep(datafiles, 'data/', ''), '_', '\_');
%  The time step in microseconds.
   dt = (xposure)*10^3;

%  Print the header
   fid1 = fopen('data/SimpleStats.data','w');
   tmp1 = [];
   tmp1 = [tmp1, 'i, '];
   tmp1 = [tmp1, 'N, '];
   tmp1 = [tmp1, 'max r, '];
   tmp1 = [tmp1, 'mean r, '];
   tmp1 = [tmp1, 'per small r, '];
   tmp1 = [tmp1, 'mu/sigma, '];
   tmp1 = [tmp1, 'M2, '];
   tmp1 = [tmp1, 'rho(1), '];
   tmp1 = [tmp1, 'rho(2) '];
   tmp1 = [tmp1, 'zero '];
   tmp1 = [tmp1, '\n'];
   fprintf(fid1, tmp1);
   format1 = [];
   format1 = [format1, '%3.0f'];  % 1 i
   format1 = [format1, '%6.0f'];  % 2 N
   format1 = [format1, '%14.4f']; % 3 max L
   format1 = [format1, '%14.4f']; % 4 mean L
   format1 = [format1, '%14.4f']; % 5 fraction of small L
   format1 = [format1, '%14.4f']; % 6 |mu|/sigma
   format1 = [format1, '%14.4f']; % 7 M2
   format1 = [format1, '%14.4f']; % 8 rho1
   format1 = [format1, '%14.4f']; % 9 rho2
   format1 = [format1, '%14.4f']; % 10 fraction of zeros
   format1 = [format1, '\n'];
%  Fit the pdf of the data with some analyitic distributions.
%  parameters(1) i
%  parameters(2) mu
%  parameters(3) sigma
%  parameters(4) s Weibull
%  parameters(5) k Weibull
%  parameters(6) s Chi
%  parameters(7) k Chi
%  parameters(8) s
%  parameters(9) a
%  parameters(10) b
%  parameters(11) sigma
%  parameters(12) xi
%  parameters(13) mu
%  Print the header
   fid2 = fopen('data/Parameters.data','w');
   tmp2 = [];
   tmp2 = [tmp2, 'i, '];		% 1
   tmp2 = [tmp2, 'mu, '];		% 2
   tmp2 = [tmp2, 'sigma, '];		% 3
   tmp2 = [tmp2, 's Weibull, '];	% 4
   tmp2 = [tmp2, 'k Weibull, '];	% 5
   tmp2 = [tmp2, 's Chi, '];		% 6
   tmp2 = [tmp2, 'k Chi, '];		% 7
   tmp2 = [tmp2, 's, '];		% 8
   tmp2 = [tmp2, 'a, '];		% 9
   tmp2 = [tmp2, 'b, '];		% 10
   tmp2 = [tmp2, 'sigma, '];		% 11
   tmp2 = [tmp2, 'xi, '];		% 12
   tmp2 = [tmp2, 'mu, '];		% 13
   tmp2 = [tmp2, '\n'];
   fprintf(fid2, tmp2);
   format2 = [];
   format2 = [format2, '%3.0f'];  %  1 i
   format2 = [format2, '%14.4f']; %  2 mean over sigma
   format2 = [format2, '%14.4f']; %  3 M2
   format2 = [format2, '%14.4f']; %  4 s Weibull
   format2 = [format2, '%14.4f']; %  5 k Weibull
   format2 = [format2, '%14.4f']; %  6 s Chi
   format2 = [format2, '%14.4f']; %  7 k Chi
   format2 = [format2, '%14.4f']; %  8 s LS
   format2 = [format2, '%14.4f']; %  9 a LS
   format2 = [format2, '%14.4f']; % 10 b LS
   format2 = [format2, '%14.4f']; % 11 sigma
   format2 = [format2, '%14.4f']; % 12 xi
   format2 = [format2, '%14.4f']; % 13 mu
   format2 = [format2, '\n']; 
%  Print the header
   fid3 = fopen('data/Estimates.data','w');
   tmp3 = [];
   tmp3 = [tmp3, 'i, '];
   tmp3 = [tmp3, 'A1, '];
   tmp3 = [tmp3, 'B1, '];
   tmp3 = [tmp3, 'R1, '];
   tmp3 = [tmp3, 'A2, '];
   tmp3 = [tmp3, 'R2, '];
   tmp3 = [tmp3, 'a1, '];
   tmp3 = [tmp3, 'b1, '];
   tmp3 = [tmp3, 'r1, '];
   tmp3 = [tmp3, 'a2, '];
   tmp3 = [tmp3, 'r2, '];
   tmp3 = [tmp3, 'alpha1, '];
   tmp3 = [tmp3, 'alpha2, '];
   tmp3 = [tmp3, '\n'];
   fprintf(fid3, tmp3);
   format3 = [];
   format3 = [format3, '%3.0f'];  %  1   i
   format3 = [format3, '%14.4f']; %  2   A1
   format3 = [format3, '%14.4f']; %  3   B1
   format3 = [format3, '%14.4f']; %  4   
   format3 = [format3, '%14.4f']; %  5 
   format3 = [format3, '%14.4f']; %  6 
   format3 = [format3, '%14.4f']; %  7 
   format3 = [format3, '%14.4f']; %  8 
   format3 = [format3, '%14.4f']; %  9 
   format3 = [format3, '%14.4f']; %  10
   format3 = [format3, '%14.4f']; %  11 
   format3 = [format3, '%14.4f']; %  12
   format3 = [format3, '%14.4f']; %  13 
   format3 = [format3, '\n']; 

%  Read starting values for the GEV fit.
   Data = dlmread('data/GEV.data','',1,0);

%  Process all of the files.
%  Save some data.
   simplestats = [];
   parameters = [];
   residuals = [];
   estimates = [];
   
   PID=unique(traj(:,7));
   PID=setdiff(PID,0);
   
%for i=1:length(datafiles)
for i = 1:length(PID)
    Ppos=traj(:,7)==PID(i);
%  (x,y)   The coordinates of the path. Read from the first two columns of
%  traj and convert from pixels to nanometers based on the pixel size and
%  magnification.
%   tmp = dlmread(datafiles{i});
%     x = tmp(:,1);
     x = traj(Ppos,1)*16/magnif*1000; %pull out x and y position data, convert to nm
%     y = tmp(:,2);
     y = traj(Ppos,2)*16/magnif*1000;

     if size(x,1) > 10
%  Start the analysis.
%
%  Do the basic stats.
  [N, maxr, meanr, smallr, normmu, M2, auto, zero, jumps, angles] = ...
	 SimpleStats(x,y);
tmpL = [tmpL,meanr];
tmpM2 = [tmpM2,M2];
   tmp =  [i, N, maxr, meanr, smallr, normmu, M2, auto(1), auto(2), zero];
   fprintf(fid1, format1, tmp);
   simplestats = [simplestats;tmp];

   binsize = 50;
   [r, pdf,mu,sigma] = PDFData(x,y,binsize);
   tmp = [i, mu, sigma];
%  initial estimates
%   mu = Data(i,2); runs through 34 GEV initial values determined by Ying et al for their data, pick the guess that works for your data
%   sigma = Data(i,3);
%   xi = Data(i,4);
   mu = Data(16,2);
   sigma = Data(16,3);
   xi = Data(16,4); 
%  Do the fits.
   [params,residual] = FitPDF(r,pdf,mu,sigma,xi);
   tmp = [tmp, params];
   fprintf(fid2, format2, tmp);
   parameters = [parameters; tmp];
   residuals = [residuals; residual];
   [TSA_PDF_data, TSA_PDF_fits] = FitPlot(r, pdf, binsize, params,i);

   [TSA_MSD_data, TSA_MSD_linearfits, TSA_MSD_nonlinfits, A1,B1,R1,A2,R2,a1,b1,r1,a2,r2,alpha1,alpha2,msd] = FitMSD(x,y,i);
   tmpA1 = [tmpA1,A1];
   tmpB1 = [tmpB1,B1];
   tmpR1 = [tmpR1,R1];
   tmpA2 = [tmpA2,A2];
   tmpR2 = [tmpR2,R2];
   tmpa1 = [tmpa1,a1];
   tmpb1 = [tmpb1,b1];
   tmpr1 = [tmpr1,r1];
   tmpa2 = [tmpa2,a2];
   tmpr2 = [tmpr2,r2];
   tmpalpha1 = [tmpalpha1,alpha1];
   tmpalpha2 = [tmpalpha2,alpha2];
   tmpMSD = [tmpMSD;msd];
%
%  Save the data to a file.
% 
   fprintf(fid3, format3, [i,A1,B1,R1,A2,R2,a1,b1,r1,a2,r2,alpha1,alpha2]);
   estimates = [estimates;[i,A1,B1,R1,A2,R2,a1,b1,r1,a2,r2,alpha1,alpha2]];
     end
end
Ratio1 = tmpA1./tmpM2;
Ratio2 = tmpA2./tmpM2;
ratio1 = (tmpalpha1.*tmpa1)./tmpM2;
ratio2 = (tmpalpha2.*tmpa2)./tmpM2;
ratiohold = ...
[ min(Ratio1),mean(Ratio1),max(Ratio1); ...
  min(Ratio2),mean(Ratio2),max(Ratio2); ...
  min(ratio1),mean(ratio1),max(ratio1); ...
  min(ratio2),mean(ratio2),max(ratio2)];
t1=(tmpR1./tmpr1)';
t2=(tmpR2./tmpr1)';
t3=(tmpr2./tmpr1)';

   fclose(fid1);
   fclose(fid2);
   fclose(fid3);
end

